//
//  B5PersonalKey.h
//  ApplicationFrameworks
//
//  Created by Roustem Karimov on 2015-03-19.
//
//

#import <Foundation/Foundation.h>

@interface B5PersonalKey : NSObject <NSSecureCoding>

@property (nonatomic, readonly) NSString *formatVersion;
@property (nonatomic, readonly) NSString *keyID;
@property (nonatomic, readonly) NSString *key;

// Database Properties
@property (nonatomic, assign) int64_t oid;
@property (nonatomic, assign) int64_t accountId;
@property (nonatomic, assign) NSUInteger createdAt;
@property (nonatomic, assign) NSUInteger updatedAt;


+ (instancetype)generate;
// Returns nil if string isn't a valid key
+ (instancetype)personalKeyFromString:(NSString *)personalKeyString;
+ (instancetype)personalKeyFromScrambledData:(NSData *)scrambledKeyData;
- (instancetype)initWithFormatVersion:(NSString *)formatVersion keyID:(NSString *)keyID key:(NSString *)key;

- (NSData *)combineWithBytes:(NSData *)bytes;
- (NSString *)formattedStringValue;

- (NSData *)scrambledPersonalKey;

@end
